#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BrokenRulesMessageBuilder : BaseTest 
	{
		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();
		}
		
		[Test]
		public void Ctor_Blank_Pass()
		{
			BOL.BrokenRulesMessageBuilder tmpBRE = new BOL.BrokenRulesMessageBuilder();

			Assert.IsNotNull(tmpBRE);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}


		[Test]
		public void AppendMessage_Pass()
		{
			BOL.BrokenRulesMessageBuilder tmpBRE = new BOL.BrokenRulesMessageBuilder();

			tmpBRE.AppendMessage("Message");

			Assert.IsTrue(tmpBRE.ToString().IndexOf("Message") > -1);
		}

		[Test]
		public void AppendMessage_Fail()
		{
			BOL.BrokenRulesMessageBuilder tmpBRE = new BOL.BrokenRulesMessageBuilder();

			tmpBRE.AppendMessage("    ");

			Assert.IsTrue(tmpBRE.ToString().IndexOf("    ") < 0);
		}

		[Test]
		public void ToString_Pass()
		{
			BOL.BrokenRulesMessageBuilder tmpBRE = new BOL.BrokenRulesMessageBuilder();
			
			tmpBRE.AppendMessage("Message");

			Assert.IsNotNull(tmpBRE.ToString());
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ToString_Fail()
		{
		}
	}

}
#endif
